
########################################################################
# downloadCreate() -	Create the dialog that is used when downloading.
#               either by an "update" press or automagically.
########################################################################
proc downloadCreate {} {
    iwidgets::dialogshell .download -title "Downloading Floppy(s) to SVD" -master .

    .download add stop -text "STOP" -command { downloadStop }

#    .download configure -modality application
    .download configure

    set download [.download childsite]

    label $download.task -relief flat -text "building..."
    gaugeCreate $download.taskgauge white 180 20
    label $download.total -relief flat -text "more..."
    gaugeCreate $download.totalgauge white 180 20


    pack $download.task -anchor n -side top -expand yes -fill x
    pack $download.taskgauge -side top -expand yes
    pack $download.total -anchor n -side top -expand yes -fill x
    pack $download.totalgauge -side top -expand yes
}

########################################################################
# downloadActivate() -	Active the download and start it up.
########################################################################
proc downloadActivate {} {
    global downloadStopVar
    global svdMemoryUsed
    global svdMemoryBlocks

    if { ! [svdCheck 0] } {
	return
    }
    set newx [expr [winfo x .] + ([winfo width .]/2) - ([winfo width .download] / 2)]
    set newy [expr [winfo y .] + ([winfo height .]/2) - ([winfo height .download] / 2)]

    if { $svdMemoryUsed > $svdMemoryBlocks } {
	tk_messageBox -parent .ffd -default ok -icon error -title "ERROR"  \
		      -type ok -message "Total size of all enabled diskettes is too big."
	return
    }
    wm geometry .download [format "+%d+%d" $newx $newy]

    set downloadStopVar 0

    .download buttonconfigure stop -state normal

    .download activate

    downloadStart
}

proc downloadStop {} {
    global downloadStopVar

    set downloadStopVar 1

    [.download childsite].task configure -text "Stopping, please wait..."
    .download buttonconfigure stop -state disabled
    update idletasks
    update
}

proc downloadStart {} {
    global downloadStopVar
    global floppyLoaded
    global floppyEnabled

    set progress 0

    [.download childsite].task configure -text "Clearing SVD..."
    update

    svdClear

    #
    # do each floppy separately
    #

    for {set i 0} { $i < 3 } {incr i} {
	if { ! $downloadStopVar } {
	    if { $floppyLoaded($i) && $floppyEnabled($i) } {
		set progress [expr $progress + [downloadFloppy $i $progress]]
	    }
	} else {
	    break
	}
    }

    svdStart

    .download deactivate
}

proc downloadFloppy {num progress} {
    global   svdMemoryUsed
    global   floppyImage
    global   floppyMemoryUsed

    # download the given floppy
    # check downloadStopVar from time to time
    # if stop is clicked, then we need to stop
    #   the problem is that it is hard to stop without causing the
    #   SVD to weird out (for now) (BREAK should be enabled somehow)
    #   So for the time being, downloadStopVar isn't checked in here

    set download [.download childsite]

    gaugeValue $download.taskgauge 0 0
    gaugeValue $download.totalgauge [expr $progress * 100 / $svdMemoryUsed] 0

    floppyOpen $num

    $download.total configure -text "Total Progress"

    $download.task configure -text "Contacting SVD..."
    update

    if { ! [svdCheck 0] } {
	return 0
    }

    $download.task configure -text [format "%s %d..." "Downloading floppy" $num]
 
    sendSVDFloppy $num gaugeUpdate $progress

    return $floppyMemoryUsed($num)
}

proc gaugeUpdate {num done total} {
    global floppyMemoryUsed
    global svdMemoryUsed

    set progress [expr $done / $total * $floppyMemoryUsed($num)]
    gaugeValue [.download childsite].totalgauge [expr $progress * 100 / $svdMemoryUsed] 0
    gaugeValue [.download childsite].taskgauge [expr $done * 100 / $total] 0
}
